{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.10.98 - 14:19:34 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, MMSystem, MMObj, MMSpectr, MMFFT,
  MMDIBCv, MMWavIn, MMSwitch, MMLEDS, MMSpin, MMUtils, MMLEDLbl, MMLevel,
  MMConect, MMDesign, MMDSPObj, MMHook;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    MMLED1: TMMLED;
    Label27: TLabel;
    MMLED2: TMMLED;
    Label28: TLabel;
    MMSpectrum2: TMMSpectrum;
    Label36: TLabel;
    lblPeak: TLabel;
    MMLED3: TMMLED;
    Label37: TLabel;
    MMLED4: TMMLED;
    Label38: TLabel;
    MMSpectrum1: TMMSpectrum;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    ckBFrames: TCheckBox;
    GroupBox1: TGroupBox;
    Kind: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    ckBDrawScale: TCheckBox;
    MMSwitch1: TMMSwitch;
    MMLEDSpin1: TMMLEDSpin;
    ckBDrawDoted: TCheckBox;
    MMSwitch3: TMMSwitch;
    ckBLogFreq: TCheckBox;
    ckBLogAmp: TCheckBox;
    MMSwitch2: TMMSwitch;
    MMSwitch4: TMMSwitch;
    MMLEDSpin2: TMMLEDSpin;
    MMLEDSpin3: TMMLEDSpin;
    MMLEDSpin4: TMMLEDSpin;
    MMLEDSpin5: TMMLEDSpin;
    ckBShowPeak: TCheckBox;
    MMLEDSpin7: TMMLEDSpin;
    ckBDrawInactive: TCheckBox;
    StartButton: TButton;
    StopButton: TButton;
    ExitButton: TButton;
    MMWaveIn1: TMMWaveIn;
    Timer1: TTimer;
    ckBLevels: TCheckBox;
    ckBPeak: TCheckBox;
    Label26: TLabel;
    Label33: TLabel;
    MMConnector1: TMMConnector;
    MMDesigner1: TMMDesigner;
    ckBGrid: TCheckBox;
    Label39: TLabel;
    Label40: TLabel;
    MMLEDSpin8: TMMLEDSpin;
    MMLEDSpin6: TMMLEDSpin;
    procedure FormCreate(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure StartButtonClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure MMSpectrumGainOverflow(Sender: TObject);
    procedure MMSpectrumPcmOverflow(Sender: TObject);
    procedure MMSwitch1Change(Sender: TObject);
    procedure MMLEDSpin1Change(Sender: TObject);
    procedure MMSpin2UpClick(Sender: TObject);
    procedure MMSpin2DownClick(Sender: TObject);
    procedure MMLEDSpin3UpClick(Sender: TObject);
    procedure MMLEDSpin3DownClick(Sender: TObject);
    procedure MMLEDSpin4Change(Sender: TObject);
    procedure MMLEDSpin5Change(Sender: TObject);
    procedure MMLEDSpin6DownClick(Sender: TObject);
    procedure MMLEDSpin6UpClick(Sender: TObject);
    procedure MMLEDSpin7Change(Sender: TObject);
    procedure MMSwitch2Change(Sender: TObject);
    procedure MMSwitch3Change(Sender: TObject);
    procedure MMSwitch4Change(Sender: TObject);
    procedure ckBLogFreqClick(Sender: TObject);
    procedure ckBLogAmpClick(Sender: TObject);
    procedure ckBDrawScaleClick(Sender: TObject);
    procedure ckBShowPeakClick(Sender: TObject);
    procedure ckBDrawDotedClick(Sender: TObject);
    procedure ckBDrawInactiveClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ckBLevelsClick(Sender: TObject);
    procedure MMConnector1Trigger(Sender: TObject);
    procedure ckBGridClick(Sender: TObject);
    procedure MMLEDSpin8Change(Sender: TObject);
  private
  public
    oldRefreshCount: Longint;
    OverFlow: Boolean;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.StartButtonClick(Sender: TObject);
begin
     if (MMWaveIn1.NumDevs = 0) then
          Application.MessageBox('Sorry, No WaveIn device installed!',
                                 'WaveIn open error',mb_OK OR mb_IconStop)
     else
     begin
        MMWaveIn1.Start;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.StopButtonClick(Sender: TObject);
begin
     MMWaveIn1.Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ExitButtonClick(Sender: TObject);
begin
     Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckBLogFreqClick(Sender: TObject);
begin
   MMSpectrum1.LogFreq := ckBLogFreq.Checked;
   MMSpectrum2.LogFreq := ckBLogFreq.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckBLogAmpClick(Sender: TObject);
begin
   MMSpectrum1.LogAmp := ckBLogAmp.Checked;
   MMSpectrum2.LogAmp := ckBLogAmp.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSwitch1Change(Sender: TObject);
begin
   MMSpectrum1.Kind := TMMSpectrumKind(MMSwitch1.Position);
   MMSpectrum2.Kind := TMMSpectrumKind(MMSwitch1.Position);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSpin2UpClick(Sender: TObject);
begin
   MMSpectrum1.FFTLength := MMSpectrum1.FFTLength * 2;
   MMSpectrum2.FFTLength := MMSpectrum2.FFTLength * 2;
   MMLEDSpin2.Value := MMSpectrum1.FFTLength;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSpin2DownClick(Sender: TObject);
begin
   MMSpectrum1.FFTLength := MMSpectrum1.FFTLength div 2;
   MMSpectrum2.FFTLength := MMSpectrum2.FFTLength div 2;
   MMLEDSpin2.Value := MMSpectrum1.FFTLength;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSwitch2Change(Sender: TObject);
begin
   MMSpectrum1.Window := TMMFFTWindow(MMSwitch2.Position);
   MMSpectrum2.Window := TMMFFTWindow(MMSwitch2.Position);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSwitch3Change(Sender: TObject);
begin
   MMSpectrum1.DecayMode := TMMDecayMode(MMSwitch3.Position);
   MMSpectrum2.DecayMode := TMMDecayMode(MMSwitch3.Position);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin1Change(Sender: TObject);
begin
   MMSpectrum1.Decay := MMLEDSpin1.Value;
   MMSpectrum2.Decay := MMLEDSpin1.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSwitch4Change(Sender: TObject);
begin
   MMSpectrum1.Gain := TMMSpectrumGain(MMSwitch4.Position);
   MMSpectrum2.Gain := TMMSpectrumGain(MMSwitch4.Position);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckBDrawScaleClick(Sender: TObject);
begin
   MMSpectrum1.DrawAmpScale  := ckBDrawScale.Checked;
   MMSpectrum1.DrawFreqScale := ckBDrawScale.Checked;
   MMSpectrum2.DrawAmpScale  := ckBDrawScale.Checked;
   MMSpectrum2.DrawFreqScale := ckBDrawScale.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin3UpClick(Sender: TObject);
var
   Factor: integer;
begin
   if (MMSpectrum1.VerticalScale < 10) then Factor := 1
   else Factor := 10;

   MMSpectrum1.VerticalScale := MMSpectrum1.VerticalScale + Factor;
   MMSpectrum2.VerticalScale := MMSpectrum2.VerticalScale + Factor;
   MMLEDSpin3.Value := MMSpectrum1.VerticalScale;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin3DownClick(Sender: TObject);
var
   Factor: integer;
begin
   if (MMSpectrum1.VerticalScale > 10) then Factor := 10
   else Factor := 1;

   MMSpectrum1.VerticalScale := MMSpectrum1.VerticalScale - Factor;
   MMSpectrum2.VerticalScale := MMSpectrum2.VerticalScale - Factor;
   MMLEDSpin3.Value := MMSpectrum1.VerticalScale;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   Overflow := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Timer1.Enabled := False;
   MMWaveIn1.Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMConnector1Trigger(Sender: TObject);
begin
   if Overflow then
   begin
      MMLED1.Enabled := False;
      MMLED2.Enabled := False;
      MMLED3.Enabled := False;
      MMLED4.Enabled := False;
      Overflow := False;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.Timer1Timer(Sender: TObject);
var
   aPeak: TPeak;
   Temp: Longint;

begin
     if ckBFrames.Checked and (MMConnector1.RefreshCountSpectrum <> OldRefreshCount) then
     begin
        Temp := MMConnector1.RefreshCountSpectrum;
        ckBFrames.Caption := ' ' + IntToStr(Temp) + ' frames/s';
        OldRefreshCount := Temp;
     end;
     MMConnector1.RefreshCountSpectrum := 0;

     if ckBPeak.Checked then
     begin
        aPeak := MMSpectrum1.Peak;
        with aPeak do
        lblPeak.Caption :=  Format(' Frequency: %7.1f Hz ',[Freq])+
                            Format(' Amplitude: %7.5f ',[Amp])+
                            Format(' %7.2f db ',[db]);
     end
     else lblPeak.Caption := '---';
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSpectrumPcmOverflow(Sender: TObject);
begin
     Overflow := True;
     if (Sender = MMSpectrum1) then MMLED1.Enabled := True
     else MMLED3.Enabled := True;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMSpectrumGainOverflow(Sender: TObject);
begin
     Overflow := True;
     if (Sender = MMSpectrum1) then MMLED2.Enabled := True
     else MMLED4.Enabled := True;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckBGridClick(Sender: TObject);
begin
   MMSpectrum1.DrawGrid := ckBGrid.Checked;
   MMSpectrum2.DrawGrid := ckBGrid.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin4Change(Sender: TObject);
begin
   MMSpectrum1.PeakDelay := MMLEDSpin4.Value;
   MMSpectrum2.PeakDelay := MMLEDSpin4.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin8Change(Sender: TObject);
begin
   MMSpectrum1.PeakSpeed := MMLEDSpin8.Value;
   MMSpectrum2.PeakSpeed := MMLEDSpin8.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin5Change(Sender: TObject);
begin
   MMSpectrum1.NumPeaks := MMLEDSpin5.Value;
   MMSpectrum2.NumPeaks := MMLEDSpin5.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckBShowPeakClick(Sender: TObject);
begin
   MMSpectrum1.DisplayPeak := ckBShowPeak.Checked;
   MMSpectrum2.DisplayPeak := ckBShowPeak.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin6UpClick(Sender: TObject);
begin
   MMSpectrum1.FrequencyScale := MMSpectrum1.FrequencyScale * 2;
   MMSpectrum2.FrequencyScale := MMSpectrum2.FrequencyScale * 2;
   MMLEDSpin6.Value := MMSpectrum1.FrequencyScale;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin6DownClick(Sender: TObject);
begin
   MMSpectrum1.FrequencyScale := MMSpectrum1.FrequencyScale div 2;
   MMSpectrum2.FrequencyScale := MMSpectrum2.FrequencyScale div 2;
   MMLEDSpin6.Value := MMSpectrum1.FrequencyScale;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMLEDSpin7Change(Sender: TObject);
begin
   MMSpectrum1.RefFreq := MMLEDSpin7.Value;
   MMSpectrum2.RefFreq := MMLEDSpin7.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckBDrawDotedClick(Sender: TObject);
begin
   MMSpectrum1.InactiveDoted := ckBDrawDoted.Checked;
   MMSpectrum1.ActiveDoted := ckBDrawDoted.Checked;
   if MMSpectrum1.ActiveDoted then MMSpectrum1.Space := 2
   else MMSpectrum1.Space := 1;
   MMSpectrum2.InactiveDoted := ckBDrawDoted.Checked;
   MMSpectrum2.ActiveDoted := ckBDrawDoted.Checked;
   if MMSpectrum2.ActiveDoted then MMSpectrum2.Space := 2
   else MMSpectrum2.Space := 1;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckBDrawInactiveClick(Sender: TObject);
begin
   MMSpectrum1.DrawInactive := ckBDrawInactive.Checked;
   MMSpectrum2.DrawInactive := ckBDrawInactive.Checked;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ckBLevelsClick(Sender: TObject);
begin
   MMLevel1.Enabled := ckBLevels.Checked;
   MMLevel2.Enabled := ckBLevels.Checked;
end;

end.
